<?php
use App\Auth;
use App\Csrf;
use App\Response;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    Response::redirect('?a=login');
}

if (!Csrf::validate($_POST['_csrf'] ?? null)) {
    Response::flash('error', 'CSRF inválido.');
    Response::redirect('?a=login');
}

$username = trim((string)($_POST['username'] ?? ''));
$password = (string)($_POST['password'] ?? '');

if (Auth::attempt($username, $password)) {
    Response::flash('success', 'Bem-vindo!');
    Response::redirect('?a=dashboard');
}

Response::flash('error', 'Usuário ou senha inválidos.');
Response::redirect('?a=login');
