<?php
use App\Fields;
use App\Modules;
use App\Response;
use App\Schema;
use App\DB;

$id = (int)($_GET['id'] ?? 0);
$moduleId = (int)($_GET['module_id'] ?? 0);

$field = Fields::find($id);
$module = Modules::find($moduleId);

if ($field && $module && (int)$field['module_id'] === $moduleId) {
    try {
        Schema::dropColumn(DB::pdo(), $module['table_name'], $field['name']);
    } catch (Throwable $e) {
        // ignore drop errors but still remove metadata?
    }
    Fields::delete($id);
    Response::flash('success', 'Campo excluído.');
}

Response::redirect('?a=fields&module_id=' . $moduleId);
