<?php
use App\Csrf;
use App\Helpers;
use App\Modules;
use App\Fields;
use App\Response;
use App\Schema;
use App\DB;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') Response::redirect('?a=dashboard');
if (!Csrf::validate($_POST['_csrf'] ?? null)) {
    Response::flash('error', 'CSRF inválido.');
    Response::redirect('?a=dashboard');
}

$moduleId = (int)($_POST['module_id'] ?? 0);
$module = Modules::find($moduleId);
if (!$module) {
    Response::flash('error', 'Módulo não encontrado.');
    Response::redirect('?a=dashboard');
}

$name = Helpers::slug((string)($_POST['name'] ?? ''));
$label = trim((string)($_POST['label'] ?? ''));
$type = (string)($_POST['type'] ?? 'text');
$required = !empty($_POST['required']) ? 1 : 0;
$options = trim((string)($_POST['options'] ?? ''));
$position = (int)($_POST['position'] ?? 0);

$allowed = ['text','textarea','number','date','datetime','email','checkbox','select'];
if (!in_array($type, $allowed, true)) $type = 'text';

if (!Helpers::validIdentifier($name)) {
    Response::flash('error', 'Nome de coluna inválido.');
    Response::redirect('?a=field_create&module_id=' . $moduleId);
}
if ($label === '') {
    Response::flash('error', 'Rótulo inválido.');
    Response::redirect('?a=field_create&module_id=' . $moduleId);
}

try {
    // ensure data table exists
    Schema::createDataTable(DB::pdo(), $module['table_name']);
    Schema::addColumn(DB::pdo(), $module['table_name'], $name, $type);

    Fields::create($moduleId, [
        'name' => $name,
        'label' => $label,
        'type' => $type,
        'required' => $required,
        'options' => $options,
        'position' => $position,
    ]);

    Response::flash('success', 'Campo criado.');
    Response::redirect('?a=fields&module_id=' . $moduleId);
} catch (Throwable $e) {
    Response::flash('error', 'Erro ao criar campo: ' . $e->getMessage());
    Response::redirect('?a=field_create&module_id=' . $moduleId);
}
