<?php
use App\Csrf;
use App\Fields;
use App\Modules;
use App\Response;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') Response::redirect('?a=dashboard');
if (!Csrf::validate($_POST['_csrf'] ?? null)) {
    Response::flash('error', 'CSRF inválido.');
    Response::redirect('?a=dashboard');
}

$id = (int)($_POST['id'] ?? 0);
$moduleId = (int)($_POST['module_id'] ?? 0);

$field = Fields::find($id);
$module = Modules::find($moduleId);

if (!$field || !$module || (int)$field['module_id'] !== $moduleId) {
    Response::flash('error', 'Campo não encontrado.');
    Response::redirect('?a=dashboard');
}

$label = trim((string)($_POST['label'] ?? ''));
$type = (string)($_POST['type'] ?? $field['type']);
$required = !empty($_POST['required']) ? 1 : 0;
$options = trim((string)($_POST['options'] ?? ''));
$position = (int)($_POST['position'] ?? 0);

$allowed = ['text','textarea','number','date','datetime','email','checkbox','select'];
if (!in_array($type, $allowed, true)) $type = (string)$field['type'];

if ($label === '') {
    Response::flash('error', 'Rótulo inválido.');
    Response::redirect('?a=field_edit&id=' . $id . '&module_id=' . $moduleId);
}

Fields::update($id, [
    'label' => $label,
    'type' => $type,
    'required' => $required,
    'options' => $options,
    'position' => $position,
]);

Response::flash('success', 'Campo atualizado (metadados).');
Response::redirect('?a=fields&module_id=' . $moduleId);
