<?php
use App\Csrf;
use App\Modules;
use App\Fields;
use App\Records;
use App\Response;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') Response::redirect('?a=dashboard');
if (!Csrf::validate($_POST['_csrf'] ?? null)) {
    Response::flash('error', 'CSRF inválido.');
    Response::redirect('?a=dashboard');
}

$moduleId = (int)($_POST['module_id'] ?? 0);
$module = Modules::find($moduleId);
if (!$module) {
    Response::flash('error', 'Módulo não encontrado.');
    Response::redirect('?a=dashboard');
}

$fields = Fields::byModule($moduleId);
$values = [];

foreach ($fields as $f) {
    $name = $f['name'];
    $type = $f['type'];
    $required = (int)$f['required'] === 1;

    if ($type === 'checkbox') {
        $v = !empty($_POST[$name]) ? 1 : 0;
    } else {
        $v = trim((string)($_POST[$name] ?? ''));
    }

    if ($required && $type !== 'checkbox' && $v === '') {
        Response::flash('error', 'Preencha o campo obrigatório: ' . $f['label']);
        Response::redirect('?a=record_create&module_id=' . $moduleId);
    }

    if ($type === 'number' && $v !== '') $v = (int)$v;
    if ($type === 'datetime' && $v !== '') $v = str_replace('T', ' ', $v);

    $values[$name] = $v;
}

try {
    Records::insert($module['table_name'], $values);
    Response::flash('success', 'Registro criado.');
    Response::redirect('?a=records&module_id=' . $moduleId);
} catch (Throwable $e) {
    Response::flash('error', 'Erro ao salvar: ' . $e->getMessage());
    Response::redirect('?a=record_create&module_id=' . $moduleId);
}
