<?php
namespace App;

final class Helpers {
    public static function e(string $s): string {
        return htmlspecialchars($s, ENT_QUOTES, 'UTF-8');
    }

    public static function slug(string $s): string {
        $s = strtolower(trim($s));
        $s = preg_replace('/[^a-z0-9_]+/i', '_', $s) ?? $s;
        $s = trim($s, '_');
        return $s;
    }

    public static function validIdentifier(string $name): bool {
        return (bool) preg_match('/^[a-zA-Z_][a-zA-Z0-9_]{0,63}$/', $name);
    }

    public static function appName(): string {
        return Env::get('APP_NAME', 'PHP CRUD Builder') ?? 'PHP CRUD Builder';
    }
}
