<?php
namespace App;

use PDO;

final class Modules {

    public static function all(): array {
        $pdo = DB::pdo();
        return $pdo->query("SELECT * FROM modules ORDER BY id DESC")->fetchAll();
    }

    public static function find(int $id): ?array {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare("SELECT * FROM modules WHERE id = ?");
        $stmt->execute([$id]);
        $row = $stmt->fetch();
        return $row ?: null;
    }

    public static function create(string $name, string $tableName): int {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare("INSERT INTO modules (name, table_name) VALUES (?, ?)");
        $stmt->execute([$name, $tableName]);
        return (int) $pdo->lastInsertId();
    }

    public static function update(int $id, string $name): void {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare("UPDATE modules SET name = ? WHERE id = ?");
        $stmt->execute([$name, $id]);
    }

    public static function delete(int $id): void {
        $pdo = DB::pdo();
        $mod = self::find($id);
        if (!$mod) return;

        // drop data table
        $table = Schema::dataTable($mod['table_name']);
        if (Helpers::validIdentifier($table)) {
            $pdo->exec("DROP TABLE IF EXISTS `{$table}`");
        }

        $stmt = $pdo->prepare("DELETE FROM modules WHERE id = ?");
        $stmt->execute([$id]);
    }
}
