<?php
namespace App;

use PDO;

final class Records {

    public static function list(string $tableName, int $limit = 50): array {
        $pdo = DB::pdo();
        $full = Schema::dataTable($tableName);
        if (!Helpers::validIdentifier($full)) throw new \RuntimeException("Tabela inválida.");
        $limit = max(1, min(200, $limit));
        $stmt = $pdo->query("SELECT * FROM `{$full}` ORDER BY id DESC LIMIT {$limit}");
        return $stmt->fetchAll();
    }

    public static function find(string $tableName, int $id): ?array {
        $pdo = DB::pdo();
        $full = Schema::dataTable($tableName);
        if (!Helpers::validIdentifier($full)) throw new \RuntimeException("Tabela inválida.");
        $stmt = $pdo->prepare("SELECT * FROM `{$full}` WHERE id = ?");
        $stmt->execute([$id]);
        $row = $stmt->fetch();
        return $row ?: null;
    }

    public static function insert(string $tableName, array $values): int {
        $pdo = DB::pdo();
        $full = Schema::dataTable($tableName);
        if (!Helpers::validIdentifier($full)) throw new \RuntimeException("Tabela inválida.");

        $cols = array_keys($values);
        $placeholders = array_fill(0, count($cols), '?');

        $colSql = implode(',', array_map(fn($c) => "`{$c}`", $cols));
        $phSql = implode(',', $placeholders);

        $stmt = $pdo->prepare("INSERT INTO `{$full}` ({$colSql}) VALUES ({$phSql})");
        $stmt->execute(array_values($values));
        return (int) $pdo->lastInsertId();
    }

    public static function update(string $tableName, int $id, array $values): void {
        $pdo = DB::pdo();
        $full = Schema::dataTable($tableName);
        if (!Helpers::validIdentifier($full)) throw new \RuntimeException("Tabela inválida.");

        $cols = array_keys($values);
        $setSql = implode(',', array_map(fn($c) => "`{$c}` = ?", $cols));

        $stmt = $pdo->prepare("UPDATE `{$full}` SET {$setSql}, updated_at = NOW() WHERE id = ?");
        $params = array_values($values);
        $params[] = $id;
        $stmt->execute($params);
    }

    public static function delete(string $tableName, int $id): void {
        $pdo = DB::pdo();
        $full = Schema::dataTable($tableName);
        if (!Helpers::validIdentifier($full)) throw new \RuntimeException("Tabela inválida.");
        $stmt = $pdo->prepare("DELETE FROM `{$full}` WHERE id = ?");
        $stmt->execute([$id]);
    }
}
