<?php
use App\Helpers;
use App\Modules;

$title = "Dashboard - " . Helpers::appName();
$modules = Modules::all();

require __DIR__ . '/partials/header.php';
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <h1 class="h4 mb-0">Dashboard</h1>
  <a class="btn btn-primary" href="?a=module_create">+ Novo módulo</a>
</div>

<div class="card shadow-sm">
  <div class="card-body">
    <p class="text-muted mb-3">Módulos são “tabelas” que você cria. Depois você adiciona campos e cadastra registros.</p>

    <?php if (!$modules): ?>
      <div class="alert alert-info mb-0">Nenhum módulo criado ainda.</div>
    <?php else: ?>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead>
            <tr>
              <th>ID</th>
              <th>Nome</th>
              <th>Tabela</th>
              <th class="text-end">Ações</th>
            </tr>
          </thead>
          <tbody>
          <?php foreach ($modules as $m): ?>
            <tr>
              <td><?= (int)$m['id'] ?></td>
              <td><?= Helpers::e($m['name']) ?></td>
              <td class="code"><?= Helpers::e('data_' . $m['table_name']) ?></td>
              <td class="text-end">
                <a class="btn btn-sm btn-outline-primary" href="?a=fields&module_id=<?= (int)$m['id'] ?>">Campos</a>
                <a class="btn btn-sm btn-outline-success" href="?a=records&module_id=<?= (int)$m['id'] ?>">Registros</a>
                <a class="btn btn-sm btn-outline-secondary" href="?a=module_edit&id=<?= (int)$m['id'] ?>">Editar</a>
                <a class="btn btn-sm btn-outline-danger" href="?a=module_delete&id=<?= (int)$m['id'] ?>" onclick="return confirm('Excluir módulo e a tabela de dados?')">Excluir</a>
              </td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    <?php endif; ?>
  </div>
</div>
<?php require __DIR__ . '/partials/footer.php'; ?>
