<?php
use App\Helpers;
use App\Csrf;
use App\Modules;
use App\Response;

$moduleId = (int)($_GET['module_id'] ?? 0);
$module = Modules::find($moduleId);
if (!$module) {
  Response::flash('error', 'Módulo não encontrado.');
  Response::redirect('?a=dashboard');
}

$title = "Novo campo - " . Helpers::appName();
require __DIR__ . '/../partials/header.php';
?>
<h1 class="h4 mb-3">Criar campo</h1>

<div class="card shadow-sm">
  <div class="card-body">
    <form method="post" action="?a=field_store">
      <input type="hidden" name="_csrf" value="<?= Helpers::e(Csrf::token()) ?>">
      <input type="hidden" name="module_id" value="<?= (int)$moduleId ?>">

      <div class="row g-3">
        <div class="col-md-4">
          <label class="form-label">Nome da coluna</label>
          <input class="form-control code" name="name" placeholder="ex: nome" required>
          <div class="form-text">Somente letras, números e _</div>
        </div>
        <div class="col-md-5">
          <label class="form-label">Rótulo</label>
          <input class="form-control" name="label" placeholder="Ex: Nome do cliente" required>
        </div>
        <div class="col-md-3">
          <label class="form-label">Tipo</label>
          <select class="form-select" name="type" required>
            <option value="text">text</option>
            <option value="textarea">textarea</option>
            <option value="number">number</option>
            <option value="date">date</option>
            <option value="datetime">datetime</option>
            <option value="email">email</option>
            <option value="checkbox">checkbox</option>
            <option value="select">select</option>
          </select>
        </div>

        <div class="col-md-4">
          <label class="form-label">Posição (ordem)</label>
          <input class="form-control" name="position" type="number" value="0">
        </div>
        <div class="col-md-4 d-flex align-items-end">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" value="1" id="required" name="required">
            <label class="form-check-label" for="required">Obrigatório</label>
          </div>
        </div>
        <div class="col-md-12">
          <label class="form-label">Opções (somente para select)</label>
          <input class="form-control" name="options" placeholder="Ex: SP,RJ,MG">
        </div>
      </div>

      <div class="mt-3">
        <button class="btn btn-primary">Criar</button>
        <a class="btn btn-link" href="?a=fields&module_id=<?= (int)$moduleId ?>">Cancelar</a>
      </div>
    </form>
  </div>
</div>
<?php require __DIR__ . '/../partials/footer.php'; ?>
