<?php
use App\Helpers;
use App\Csrf;
use App\Fields;
use App\Modules;
use App\Response;

$moduleId = (int)($_GET['module_id'] ?? 0);
$fieldId = (int)($_GET['id'] ?? 0);

$module = Modules::find($moduleId);
$field = Fields::find($fieldId);

if (!$module || !$field || (int)$field['module_id'] !== $moduleId) {
  Response::flash('error', 'Campo não encontrado.');
  Response::redirect('?a=dashboard');
}

$title = "Editar campo - " . Helpers::appName();
require __DIR__ . '/../partials/header.php';
?>
<h1 class="h4 mb-3">Editar campo</h1>

<div class="card shadow-sm">
  <div class="card-body">
    <form method="post" action="?a=field_update">
      <input type="hidden" name="_csrf" value="<?= Helpers::e(Csrf::token()) ?>">
      <input type="hidden" name="id" value="<?= (int)$field['id'] ?>">
      <input type="hidden" name="module_id" value="<?= (int)$moduleId ?>">

      <div class="row g-3">
        <div class="col-md-4">
          <label class="form-label">Nome da coluna</label>
          <input class="form-control code" value="<?= Helpers::e($field['name']) ?>" disabled>
          <div class="form-text">Por segurança, o nome da coluna não é editável aqui.</div>
        </div>
        <div class="col-md-5">
          <label class="form-label">Rótulo</label>
          <input class="form-control" name="label" value="<?= Helpers::e($field['label']) ?>" required>
        </div>
        <div class="col-md-3">
          <label class="form-label">Tipo</label>
          <select class="form-select" name="type" required>
            <?php foreach (['text','textarea','number','date','datetime','email','checkbox','select'] as $t): ?>
              <option value="<?= $t ?>" <?= $field['type']===$t ? 'selected' : '' ?>><?= $t ?></option>
            <?php endforeach; ?>
          </select>
          <div class="form-text">A coluna não muda de tipo no banco (simplificação). Para mudar, recrie o campo.</div>
        </div>

        <div class="col-md-4">
          <label class="form-label">Posição (ordem)</label>
          <input class="form-control" name="position" type="number" value="<?= (int)$field['position'] ?>">
        </div>
        <div class="col-md-4 d-flex align-items-end">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" value="1" id="required" name="required" <?= $field['required'] ? 'checked' : '' ?>>
            <label class="form-check-label" for="required">Obrigatório</label>
          </div>
        </div>
        <div class="col-md-12">
          <label class="form-label">Opções (somente para select)</label>
          <input class="form-control" name="options" value="<?= Helpers::e((string)$field['options']) ?>" placeholder="Ex: SP,RJ,MG">
        </div>
      </div>

      <div class="mt-3">
        <button class="btn btn-primary">Salvar</button>
        <a class="btn btn-link" href="?a=fields&module_id=<?= (int)$moduleId ?>">Voltar</a>
      </div>
    </form>
  </div>
</div>
<?php require __DIR__ . '/../partials/footer.php'; ?>
