<?php
use App\Helpers;
use App\Modules;
use App\Fields;
use App\Response;

$moduleId = (int)($_GET['module_id'] ?? 0);
$module = Modules::find($moduleId);
if (!$module) {
  Response::flash('error', 'Módulo não encontrado.');
  Response::redirect('?a=dashboard');
}

$title = "Campos - " . Helpers::appName();
$fields = Fields::byModule($moduleId);

require __DIR__ . '/../partials/header.php';
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h1 class="h4 mb-1">Campos</h1>
    <div class="text-muted small">Módulo: <strong><?= Helpers::e($module['name']) ?></strong> • Tabela: <span class="code"><?= Helpers::e('data_' . $module['table_name']) ?></span></div>
  </div>
  <div class="d-flex gap-2">
    <a class="btn btn-outline-success" href="?a=records&module_id=<?= (int)$moduleId ?>">Registros</a>
    <a class="btn btn-primary" href="?a=field_create&module_id=<?= (int)$moduleId ?>">+ Novo campo</a>
  </div>
</div>

<div class="card shadow-sm">
  <div class="card-body">
    <?php if (!$fields): ?>
      <div class="alert alert-info mb-0">Nenhum campo criado ainda.</div>
    <?php else: ?>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead>
            <tr>
              <th>Pos</th>
              <th>Nome (coluna)</th>
              <th>Rótulo</th>
              <th>Tipo</th>
              <th>Obrig.</th>
              <th class="text-end">Ações</th>
            </tr>
          </thead>
          <tbody>
          <?php foreach ($fields as $f): ?>
            <tr>
              <td><?= (int)$f['position'] ?></td>
              <td class="code"><?= Helpers::e($f['name']) ?></td>
              <td><?= Helpers::e($f['label']) ?></td>
              <td><span class="badge text-bg-secondary"><?= Helpers::e($f['type']) ?></span></td>
              <td><?= $f['required'] ? 'Sim' : 'Não' ?></td>
              <td class="text-end">
                <a class="btn btn-sm btn-outline-secondary" href="?a=field_edit&id=<?= (int)$f['id'] ?>&module_id=<?= (int)$moduleId ?>">Editar</a>
                <a class="btn btn-sm btn-outline-danger" href="?a=field_delete&id=<?= (int)$f['id'] ?>&module_id=<?= (int)$moduleId ?>" onclick="return confirm('Excluir campo e remover coluna do banco?')">Excluir</a>
              </td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    <?php endif; ?>
  </div>
</div>

<a class="btn btn-link mt-3" href="?a=dashboard">← Voltar</a>
<?php require __DIR__ . '/../partials/footer.php'; ?>
