<?php
use App\Helpers;
use App\Csrf;

$title = "Login - " . Helpers::appName();
require __DIR__ . '/partials/header.php';
?>
<div class="row justify-content-center">
  <div class="col-lg-5">
    <div class="card shadow-sm">
      <div class="card-body p-4">
        <h1 class="h4 mb-3">Entrar</h1>
        <form method="post" action="?a=do_login">
          <input type="hidden" name="_csrf" value="<?= Helpers::e(Csrf::token()) ?>">
          <div class="mb-3">
            <label class="form-label">Usuário</label>
            <input class="form-control" name="username" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Senha</label>
            <input class="form-control" name="password" type="password" required>
          </div>
          <button class="btn btn-primary w-100">Entrar</button>
        </form>
        <div class="text-muted small mt-3">
          Se ainda não instalou: acesse <a href="install.php">/public/install.php</a>.
        </div>
      </div>
    </div>
  </div>
</div>
<?php require __DIR__ . '/partials/footer.php'; ?>
