<?php
use App\Helpers;
use App\Csrf;
use App\Modules;
use App\Response;

$id = (int)($_GET['id'] ?? 0);
$module = Modules::find($id);
if (!$module) {
  Response::flash('error', 'Módulo não encontrado.');
  Response::redirect('?a=dashboard');
}

$title = "Editar módulo - " . Helpers::appName();
require __DIR__ . '/../partials/header.php';
?>
<h1 class="h4 mb-3">Editar módulo</h1>

<div class="card shadow-sm">
  <div class="card-body">
    <form method="post" action="?a=module_update">
      <input type="hidden" name="_csrf" value="<?= Helpers::e(Csrf::token()) ?>">
      <input type="hidden" name="id" value="<?= (int)$module['id'] ?>">
      <div class="mb-3">
        <label class="form-label">Nome</label>
        <input class="form-control" name="name" value="<?= Helpers::e($module['name']) ?>" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Tabela</label>
        <input class="form-control code" value="<?= Helpers::e('data_' . $module['table_name']) ?>" disabled>
        <div class="form-text">Por segurança, o identificador da tabela não pode ser alterado por aqui.</div>
      </div>
      <button class="btn btn-primary">Salvar</button>
      <a class="btn btn-link" href="?a=dashboard">Voltar</a>
    </form>
  </div>
</div>
<?php require __DIR__ . '/../partials/footer.php'; ?>
