<?php
use App\Helpers;
use App\Csrf;
use App\Modules;
use App\Fields;
use App\Response;

$moduleId = (int)($_GET['module_id'] ?? 0);
$module = Modules::find($moduleId);
if (!$module) {
  Response::flash('error', 'Módulo não encontrado.');
  Response::redirect('?a=dashboard');
}
$fields = Fields::byModule($moduleId);
$values = [];

$title = "Novo registro - " . Helpers::appName();
require __DIR__ . '/../partials/header.php';
?>
<h1 class="h4 mb-3">Novo registro</h1>

<div class="card shadow-sm">
  <div class="card-body">
    <form method="post" action="?a=record_store">
      <input type="hidden" name="_csrf" value="<?= Helpers::e(Csrf::token()) ?>">
      <input type="hidden" name="module_id" value="<?= (int)$moduleId ?>">

<?php foreach ($fields as $f): 
  $name = $f['name'];
  $label = $f['label'];
  $type = $f['type'];
  $required = (int)$f['required'] === 1;
  $val = $values[$name] ?? '';
?>
  <div class="mb-3">
    <label class="form-label"><?= \App\Helpers::e($label) ?><?= $required ? ' *' : '' ?></label>

    <?php if ($type === 'textarea'): ?>
      <textarea class="form-control" name="<?= \App\Helpers::e($name) ?>" rows="4" <?= $required ? 'required' : '' ?>><?= \App\Helpers::e((string)$val) ?></textarea>

    <?php elseif ($type === 'checkbox'): ?>
      <div class="form-check">
        <input class="form-check-input" type="checkbox" id="cb_<?= \App\Helpers::e($name) ?>" name="<?= \App\Helpers::e($name) ?>" value="1" <?= ((int)$val) ? 'checked' : '' ?>>
        <label class="form-check-label" for="cb_<?= \App\Helpers::e($name) ?>">Marcar</label>
      </div>

    <?php elseif ($type === 'select'): 
      $opts = array_filter(array_map('trim', explode(',', (string)$f['options'])));
    ?>
      <select class="form-select" name="<?= \App\Helpers::e($name) ?>" <?= $required ? 'required' : '' ?>>
        <option value="">Selecione...</option>
        <?php foreach ($opts as $o): ?>
          <option value="<?= \App\Helpers::e($o) ?>" <?= ((string)$val === (string)$o) ? 'selected' : '' ?>><?= \App\Helpers::e($o) ?></option>
        <?php endforeach; ?>
      </select>

    <?php else: 
      $htmlType = match ($type) {
        'email' => 'email',
        'number' => 'number',
        'date' => 'date',
        'datetime' => 'datetime-local',
        default => 'text'
      };
      // datetime-local expects YYYY-MM-DDTHH:MM
      if ($type === 'datetime' && $val) {
        $val = str_replace(' ', 'T', (string)$val);
      }
    ?>
      <input class="form-control" type="<?= \App\Helpers::e($htmlType) ?>" name="<?= \App\Helpers::e($name) ?>" value="<?= \App\Helpers::e((string)$val) ?>" <?= $required ? 'required' : '' ?>>
    <?php endif; ?>

  </div>
<?php endforeach; ?>


      <button class="btn btn-primary">Salvar</button>
      <a class="btn btn-link" href="?a=records&module_id=<?= (int)$moduleId ?>">Cancelar</a>
    </form>
  </div>
</div>
<?php require __DIR__ . '/../partials/footer.php'; ?>
